﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RevisionAnalyser.Global;
using RevisionAnalyser.Projects.RecoderProject;
using RecoderProject;

namespace RevisionAnalyser.Projects.RecoderProject.Tasks
{
    public class RecoderTask : Task
    {
        public override void Run()
        {
        }

        protected RecoderAnalyser GetRecoderAnalyser(RecoderProject project)
        {
            RecoderAnalyser analyser = project.GetRecoderAnalyser();
            analyser.ErrorReceived += new ErrorReceivedEventHandler(analyser_ErrorReceived);
            analyser.WarningReceived += new WarningReceivedEventHandler(analyser_WarningReceived);
            analyser.StatusChanged += new StatusChangedEventHandler(analyser_StatusChanged);
            analyser.ProcessComplete += new ProcessCompleteEventHandler(analyser_ProcessComplete);
            return analyser;
        }

        protected void analyser_ProcessComplete(object sender, ProcessCompleteEventArgs e)
        {
            AddLog(String.Format("RecoderAnalyser: {0}", e.Message), Constants.COLOR_GREEN);
        }

        protected void analyser_StatusChanged(object sender, StatusChangedEventArgs e)
        {
            if (e.Type.Equals(StatusType.VALUE))
            {
                UpdateSubProgressValue(e.Value);
            }
            else if (e.Type.Equals(StatusType.MESSAGE))
            {
                AddLog(e.Message, Constants.COLOR_GREEN);
            }
        }

        protected void analyser_WarningReceived(object sender, WarningReceivedEventArgs e)
        {
            AddLog(String.Format("Warning: {0}", e.Message), Constants.COLOR_ORANGE);
        }

        protected void analyser_ErrorReceived(object sender, ErrorReceivedEventArgs e)
        {
            AddLog(String.Format("Error {0}: {1}", e.Number, e.Message), Constants.COLOR_RED);
        }
    }
}
